// (c) 1999 - 2025 OneSpan North America Inc. All rights reserved.


/////////////////////////////////////////////////////////////////////////////
//
//
// This file is example source code. It is provided for your information and
// assistance. See your licence agreement for details and the terms and
// conditions of the licence which governs the use of the source code. By using
// such source code you will be accepting these terms and conditions. If you do
// not wish to accept these terms and conditions, DO NOT OPEN THE FILE OR USE
// THE SOURCE CODE.
//
// Note that there is NO WARRANTY.
//
//////////////////////////////////////////////////////////////////////////////


import MSSOrchestration
import MSSNotificationClient
import UIKit

extension String {
    var localized: String {
        return NSLocalizedString(self, comment: "")
    }
}

extension Notification.Name {
    static let managerNewDeviceToken = Notification.Name("NotificationManagerNewDeviceToken")
    static let managerPending        = Notification.Name("NotificationManagerPendingNotification")
    static let managerErrorWithParse = Notification.Name("NotificationManagerErrorWithParseNotification")
}

extension OrchestrationUser: SelectableItem {
    func textToDisplay() -> String {
        return [identifier, domain].compactMap { $0 }.joined(separator: "@")
    }
}

extension NotificationError {
    var formatted: String {
        [
            "\n",
            "errorCode: \(errorCode)",
            errorDescription,
            failureReason,
            recoverySuggestion
        ]
        .compactMap { $0 }
        .filter { !$0.isEmpty }
        .joined(separator: "\n")
    }
}

extension UIColor {
    static var navBarColor: UIColor? {
        return UIColor(named: "navBarColor")
    }
    static var pinText: UIColor? {
        return UIColor(named: "pinText")
    }
}
